package com.bitbof.escape;

import org.lwjgl.Sys;
import org.lwjgl.examples.spaceinvaders.Texture;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;

import com.bitbof.escape.entities.World;
 
/**
 * Escape the Blob Ludum Dare #21
 *
 * @author bitbof <bitbof@gmail.com>
 * @version 1.0
 */
public class Escape {

  public static final String GAME_TITLE = "Elastic Prison";
  private static final int FRAMERATE = 60;
  private static final boolean FULLSCREEN = false;
  private static final int WIDTH = 1024, HEIGHT = 768;
  
  private static boolean finished;
  private static World world = new World();
  
  
  
 
  /**
   * Application init
   * @param args Commandline args
   */
  public static void main(String[] args) {
 
    try {
      init(false);//fullscreen);
      run();
    } catch (Exception e) {
      e.printStackTrace(System.err);
      Sys.alert(GAME_TITLE, "An error occured and the game will exit.");
    } finally {
      cleanup();
    }
    System.exit(0);
  }
 
  /**
   * Initialise the game
   * @throws Exception if init fails
   */
  private static void init(boolean fullscreen) throws Exception {
    // Create a fullscreen window with 1:1 orthographic 2D projection (default)
    Display.setTitle(GAME_TITLE);
    Display.setFullscreen(FULLSCREEN);
    
    // Enable vsync if we can (due to how OpenGL works, it cannot be guarenteed to always work)
    Display.setVSyncEnabled(true);
    if(!FULLSCREEN)
    	Display.setDisplayMode(new DisplayMode(Escape.WIDTH, Escape.HEIGHT));
    // Create default display of 640x480
    Display.create();
    Art.init();
    Sound.init();
    //Sound.playSound(Sound.MUSIC);
    
    GL11.glEnable(GL11.GL_TEXTURE_2D);
    GL11.glEnable(GL11.GL_BLEND);
    GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
  }
 
  /**
   * Runs the game (the "main loop")
   */
  private static void run() {
 
    while (!finished) {
      // Always call Window.update(), all the time - it does some behind the
      // scenes work, and also displays the rendered output
      Display.update();
 
      // Check for close requests
      if (Display.isCloseRequested()) {
    	  finished = true;
    	  cleanup();
      } 
 
      // The window is in the foreground, so we should play the game
      else if (Display.isActive()) {
        logic();
        render();
        Display.sync(FRAMERATE);
      } 
 
      // The window is not in the foreground, so we can allow other stuff to run and
      // infrequently update
      else {
        try {
          Thread.sleep(100);
        } catch (InterruptedException e) {
        }
        logic();
 
	// Only bother rendering if the window is visible or dirty
        if (Display.isVisible() || Display.isDirty()) {
          render();
        }
      }
    }
  }
 
  /**
   * Do any game-specific cleanup
   */
  private static void cleanup() {
    // Close the window
	  Sound.clearup();
    Display.destroy();
  }
 
  /**
   * Do all calculations, handle input, etc.
   */
  private static long lastTime = System.nanoTime();
  private static long unprocessedTime = System.nanoTime();
  private static long pausecounter = 0;
  private static boolean pause = false;
  private static void logic() {
    // Example input handler: we'll check for the ESC key and finish the game instantly when it's pressed
	if (Keyboard.isKeyDown(Keyboard.KEY_ESCAPE)) {
      finished = true;
    }
	if(Keyboard.isKeyDown(Keyboard.KEY_P)) {
		if(pausecounter <= 0) {
			pausecounter = 50;
			
			pause = !pause;
		}
	}
	
	long now = System.nanoTime();
    unprocessedTime += now - lastTime;
    lastTime = now;

    int max = 10;
    while (unprocessedTime > 0) {
        unprocessedTime -= 1000000000 / 60;
        if(!pause)
        	world.tick();
        pausecounter--;
        if (max-- == 0) {
            unprocessedTime = 0;
            break;
        }
    }
  }
  
  private static void render() {
	  
	    GL11.glMatrixMode(GL11.GL_PROJECTION);
	    GL11.glLoadIdentity();
	    GL11.glOrtho(0, Display.getDisplayMode().getWidth(), 0, Display.getDisplayMode().getHeight(), -1, 1);
	    GL11.glMatrixMode(GL11.GL_MODELVIEW);
	 
	    // clear the screen
	    GL11.glClear(GL11.GL_COLOR_BUFFER_BIT | GL11.GL_STENCIL_BUFFER_BIT);
	 
	    // center square according to screen size
	    GL11.glPushMatrix();
	    GL11.glTranslatef(Display.getDisplayMode().getWidth() / 2, Display.getDisplayMode().getHeight() / 2, 0.0f);
	    world.renderBackground();
	    GL11.glScalef(world.camera.zoom, world.camera.zoom, 0);
	    GL11.glTranslatef(-world.camera.pos.x, -world.camera.pos.y, 0);
	    world.render();
	    world.renderEnts();
	    GL11.glPopMatrix();
	    if(pause) {
			Art.bg01.bind();
			GL11.glPushMatrix();
			GL11.glTranslated(0,0,0);
	
			GL11.glColor4f(0, 0, 0, 0.6f);
	
			Texture texture = Art.blob;
			// rotate square according to angle
			GL11.glRotatef(0, 0, 0, 1);
			GL11.glScalef(8000, 8000, 0);
			GL11.glBegin(GL11.GL_QUADS);
				GL11.glTexCoord2f(0, 0);
				GL11.glVertex2f(-0.5f, -0.5f);
				GL11.glTexCoord2f(0, texture.getHeight());
				GL11.glVertex2f(0.5f, -0.5f);
				GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
				GL11.glVertex2f(0.5f, 0.5f);
				GL11.glTexCoord2f(texture.getWidth(), 0);
				GL11.glVertex2f(-0.5f, 0.5f);
			GL11.glEnd();
	
			GL11.glPopMatrix();
			
			Art.pause.bind();
			GL11.glPushMatrix();
			GL11.glTranslatef(Display.getDisplayMode().getWidth() / 2, Display.getDisplayMode().getHeight() / 2, 0.0f);
	
			GL11.glColor4f(1, 1, 1, 1);
	
			texture = Art.pause;
			// rotate square according to angle
			GL11.glRotatef(-90, 0, 0, 1);
			GL11.glScalef(128, 128, 0);
			GL11.glBegin(GL11.GL_QUADS);
				GL11.glTexCoord2f(0, 0);
				GL11.glVertex2f(-0.5f, -0.5f);
				GL11.glTexCoord2f(0, texture.getHeight());
				GL11.glVertex2f(0.5f, -0.5f);
				GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
				GL11.glVertex2f(0.5f, 0.5f);
				GL11.glTexCoord2f(texture.getWidth(), 0);
				GL11.glVertex2f(-0.5f, 0.5f);
			GL11.glEnd();
	
			GL11.glPopMatrix();
		}
	   
  }
}
